// C Source File
// Created 2.1.01; 12:28:29

#include "Buffered Graphics.h"

int CurGrayPlanes = 1;
PLCDBuffer *GrayPlanes = 0;

void GraphInit(int PlaneCount)
{
	if (PlaneCount >= 2 && GrayMode (GRAY_ON))
		CurGrayPlanes = 2;
	else
		CurGrayPlanes = 1;
	
	GrayPlanes = malloc (sizeof (PLCDBuffer) * CurGrayPlanes);
	if (CurGrayPlanes == 1)
		GrayPlanes [0] = LCD_MEM;
	else
	{
		register int Plane;
		for (Plane = 0; Plane < CurGrayPlanes; Plane++)
			GrayPlanes [Plane] = GetPlane (CurGrayPlanes - Plane - 1);
	}
}

void GraphDone(void)
{
	free (GrayPlanes);
	GrayMode (GRAY_OFF);
}

PGraphBuffer CreateBuf(int PlaneCount)
{
	PGraphBuffer Buffer = malloc (sizeof (TGraphBuffer) + sizeof (TLCDBuffer) * PlaneCount);
	Buffer->PlaneCount = PlaneCount;
	ClrBuf (Buffer);
	return Buffer;
}

void ClrBuf(PGraphBuffer Buffer)
{
	register int I, Line;
	for (I = 0; I < Buffer->PlaneCount; I++)
		for (Line = 0; Line < LCDHeight; Line++)
			memset (&(Buffer->Planes [I] [Line * LCDByteWidth]), 0, LCDRealByteWidth);
}

void FlushBuf(PGraphBuffer Buffer)
{
	register int I, Line;
	for (I = 0; I < Buffer->PlaneCount; I++)
		for (Line = 0; Line < LCDHeight; Line++)
			memcpy (&((*(GrayPlanes [I])) [Line * LCDByteWidth]), &(Buffer->Planes [I] [Line * LCDByteWidth]), LCDRealByteWidth);
}

void ActivateBuf(PGraphBuffer Buffer, int Plane)
{
	PortSet (&(Buffer->Planes [Plane]), LCDWidth - 1, LCDHeight - 1);
}

void DrawHLineBuf(PGraphBuffer Buffer, int X1, int X2, int Y, TColor Color)
{
	if (X1 > X2)
	{
		register int Tmp = X1;
		X1 = X2;
		X2 = Tmp;
	}
	if (Y < 0) Y = 0;
	if (Y >= LCDHeight) Y = LCDHeight - 1;
	if (X1 < 0) X1 = 0;
	if (X2 >= LCDWidth) X2 = LCDWidth - 1;
	
	if (X1 <= X2)
	{
		unsigned char MaskByte1, MaskByte2;
		int X1Pos = GetBufPos (X1, Y) + 1;
		int X2Pos = GetBufPos (X2, Y);
		if (X1Pos > X2Pos)
		{
			MaskByte1 = GetByteMask (7 - (X2 & 0x07), 7 - (X1 & 0x07));
			MaskByte2 = 0;
		}
		else
		{
			MaskByte1 = GetByteMask (0, 7 - (X1 & 0x07));
			MaskByte2 = GetByteMask (7 - (X2 & 0x07), 7);
		}
		
		{
			register unsigned char Mask;
			register PLCDBuffer PlanePtr;
			register unsigned char *MaskPtr;

			register int Plane;
			for (Plane = 0; Plane < Buffer->PlaneCount; Plane++)
			{
				Mask = GetDitherMask (Plane, Color, Y);
				PlanePtr = &(Buffer->Planes [Plane]);
				MaskPtr = &((*PlanePtr) [X1Pos - 1]);
				if (MaskByte1 && Mask != 0xFF)
					*MaskPtr &= ~MaskByte1;
				*MaskPtr |= MaskByte1 & Mask;
				if (X1Pos < X2Pos)
					memset (&(Buffer->Planes [Plane] [X1Pos]), Mask, X2Pos - X1Pos);
				MaskPtr = &((*PlanePtr) [X2Pos]);
				if (MaskByte2 && Mask != 0xFF)
					*MaskPtr &= ~MaskByte2;
				*MaskPtr |= MaskByte2 & Mask;
			}
		}
	}
}

void DrawVLineBuf(PGraphBuffer Buffer, int X, int Y1, int Y2, TColor Color)
{
	if (Y1 > Y2)
	{
		register int Tmp = Y1;
		Y1 = Y2;
		Y2 = Tmp;
	}
	if (Y1 < 0)
		Y1 = 0;
	if (Y2 >= LCDHeight)
		Y2 = LCDHeight - 1;
	if (X < 0) X = 0;
	if (X >= LCDWidth) X = LCDWidth - 1;
	
	if (Y1 <= Y2)
	{
		unsigned char MaskByte = 1 << (7 - (X & 0x07));
		int XPos;
		
		register int Plane;
		register int I;
		register PLCDBuffer PlanePtr;
		
		for (Plane = 0; Plane < Buffer->PlaneCount; Plane++)
		{
			PlanePtr = &(Buffer->Planes [Plane]);
			
			for (I = Y1; I <= Y2; I++)
			{
				XPos = GetBufPos (X, I);
				if (PlaneIsBlack (Plane, Color))
					(*PlanePtr) [XPos] |= MaskByte;
				else
					(*PlanePtr) [XPos] &= ~MaskByte;
			}
		}
	}
}

void DrawFullHLineBuf(PGraphBuffer Buffer, int Y, TColor Color)
{
	if (Y < 0) Y = 0;
	if (Y >= LCDHeight) Y = LCDHeight - 1;

	{
		register int Pos = GetBufPos (0, Y);
		
		register int Plane;
		for (Plane = 0; Plane < Buffer->PlaneCount; Plane++)
			memset (&(Buffer->Planes [Plane] [Pos]), GetDitherMask (Plane, Color, Y), LCDRealByteWidth);
	}
}

void DrawFullHLinesBuf(PGraphBuffer Buffer, int Y1, int Y2, TColor Color)
{
	if (Y1 > Y2)
	{
		register int Tmp = Y1;
		Y1 = Y2;
		Y2 = Tmp;
	}
	
	if (Y1 < 0) Y1 = 0;
	if (Y2 >= LCDHeight) Y2 = LCDHeight - 1;
	
	{
		register int Plane;
		register int Line;
		register PLCDBuffer PlanePtr;

		for (Plane = 0; Plane < Buffer->PlaneCount; Plane++)
		{
			PlanePtr = &(Buffer->Planes [Plane]);
			
			for (Line = Y1; Line <= Y2; Line++)
				memset (&((*PlanePtr) [GetBufPos (0, Line)]), GetDitherMask (Plane, Color, Line), LCDRealByteWidth);
		}
	}
}

void DrawRectBuf(PGraphBuffer Buffer, int X1, int Y1, int X2, int Y2, TColor Color)
{
	if (Y1 > Y2)
	{
		register int Tmp = Y1;
		Y1 = Y2;
		Y2 = Tmp;
	}
	if (Y1 < 0)
		Y1 = 0;
	if (Y2 >= LCDHeight)
		Y2 = LCDHeight - 1;
	
	{
		register int I;
		for (I = Y1; I <= Y2; I++)
			DrawHLineBuf (Buffer, X1, X2, I, Color);
	}
}

unsigned char GetDitherMask(int Plane, TColor Color, int Y)
{
	if (Plane >= CurGrayPlanes - 2)
	{
		unsigned char Val = GetDitherVal (Color);
		if (Plane == CurGrayPlanes - 1)
		{
			if (IsMinorDithered (Val))
				return (0x55 << (Y & 0x1));
		}
		else
		{
			if (IsMajorDithered (Val))
				return (0xAA >> (Y & 0x1));
		}
	}
	
	return (PlaneIsBlack (Plane, Color) ? 0xFF : 0x00);
}
